<?php
/**
 * StablePay WooCommerce Blocks 支付支持
 *
 * @package StablePay_WooCommerce
 */

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

// 防止直接访问
if (!defined('ABSPATH')) {
    exit;
}

/**
 * StablePay Blocks Payment Method 类
 *
 * 为 WooCommerce Checkout Blocks 提供支付方式支持
 */
final class WC_StablePay_Blocks_Support extends AbstractPaymentMethodType {
    /**
     * 支付方式名称
     *
     * @var string
     */
    protected $name = 'stablepay';

    /**
     * 初始化
     */
    public function initialize() {
        $this->settings = get_option('woocommerce_stablepay_settings', array());
    }

    /**
     * 判断支付方式是否可用
     *
     * @return bool
     */
    public function is_active() {
        return !empty($this->settings['enabled']) && $this->settings['enabled'] === 'yes';
    }

    /**
     * 注册脚本
     *
     * @return array 脚本句柄列表
     */
    public function get_payment_method_script_handles() {
        $asset_path = STABLEPAY_WC_PLUGIN_DIR . 'assets/js/blocks.asset.php';
        $version = STABLEPAY_WC_VERSION;
        $dependencies = array();

        if (file_exists($asset_path)) {
            $asset = require $asset_path;
            $version = isset($asset['version']) ? $asset['version'] : $version;
            $dependencies = isset($asset['dependencies']) ? $asset['dependencies'] : $dependencies;
        }

        wp_register_script(
            'stablepay-blocks',
            STABLEPAY_WC_PLUGIN_URL . 'assets/js/blocks.js',
            $dependencies,
            $version,
            true
        );

        return array('stablepay-blocks');
    }

    /**
     * 获取支付方式数据
     *
     * @return array 支付方式配置数据
     */
    public function get_payment_method_data() {
        return array(
            'title' => $this->get_setting('title', __('StablePay - 稳定币支付', 'stablepay-woocommerce')),
            'description' => $this->get_setting('description', __('使用 USDT、USDC 等稳定币安全快速支付', 'stablepay-woocommerce')),
            'supports' => $this->get_supported_features(),
            'icon' => STABLEPAY_WC_PLUGIN_URL . 'assets/images/logo.svg',
        );
    }

    /**
     * 获取支持的功能
     *
     * @return array
     */
    public function get_supported_features() {
        $gateway = new WC_StablePay_Gateway();
        return $gateway->supports;
    }
}
